<?php
require "config/database.php";
require "config/function.php";
require "config/functions.crud.php";
?>

<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta content="width=device-width, initial-scale=1, maximum-scale=1, shrink-to-fit=no" name="viewport">
    <title><?= $setting['nama_sekolah'] ?></title>

    <!-- General CSS Files -->
    <!-- <link rel="stylesheet" href="assets/modules/bootstrap/css/bootstrap.min.css"> -->
    <link rel="stylesheet" href="assets/modules/fontawesome/css/all.min.css">

    <!-- CSS Libraries -->
    <link rel="stylesheet" href="assets/modules/select2/dist/css/select2.min.css">
    <link rel="stylesheet" href="assets/modules/bootstrap-daterangepicker/daterangepicker.css">
    <link rel="stylesheet" href="assets/modules/izitoast/css/iziToast.min.css">
    <link rel="stylesheet" href="assets/modules/animate/animate.css">
    <!-- CSS DATATABLE -->
    <link rel="stylesheet" href="assets/modules/datatables/datatables.min.css">
    <link rel="stylesheet" href="assets/modules/datatables/DataTables-1.10.16/css/dataTables.bootstrap4.min.css">
    <!-- Template CSS -->
    <link rel="stylesheet" href="assets/css/style.css">
    <link rel="stylesheet" href="assets/css/components.css">
    <!-- tamplate ui -->
    <link href="assets/ui/css/nucleo-icons.css" rel="stylesheet" />
    <link href="assets/ui/css/nucleo-svg.css" rel="stylesheet" />
    <link rel="stylesheet" href="assets/ui/css/custDashboard.css">
    <link id="pagestyle" href="assets/ui/css/soft-ui-dashboard.css" rel="stylesheet" />
    <link href="https://fonts.googleapis.com/css?family=Open+Sans:300,400,600,700" rel="stylesheet" />
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.14.0/css/all.min.css" />
    <script src="https://code.jquery.com/jquery-3.6.4.min.js"></script>
    <!-- Start GA -->
    <script async src="https://www.googletagmanager.com/gtag/js?id=UA-94034622-3"></script>
    <script>
        window.dataLayer = window.dataLayer || [];

        function gtag() {
            dataLayer.push(arguments);
        }
        gtag('js', new Date());

        gtag('config', 'UA-94034622-3');
    </script>
    <!-- /END GA -->
    <style>
        .loader {
            position: fixed;
            left: 0px;
            top: 0px;
            width: 100%;
            height: 100%;
            z-index: 9999;
            background: url('assets/img/spinner-primary.svg') 50% 50% no-repeat rgb(249, 249, 249);
            opacity: .9;
        }
    </style>
    <style>
        .main-navbar {
            margin: 0;
            position: sticky;
            top: 0;
            z-index: 9;
            /* Mengatur z-index agar navbar muncul di atas konten lainnya */
            width: 100%;
        }
    </style>

</head>

<body class="layout-3">
    <div class='loader'></div>
    <div class="chating" style=" z-index: 99999; width: 50px; padding: 15px;  bottom: 0; position: fixed; ">
        <a href="https://api.whatsapp.com/send?phone=+62<?= $setting['nolivechat'] ?>&text=<?= $setting['livechat'] ?>">

            <img src="assets/img/wa.png" width="150"> </a>
    </div>
    <nav class="navbar navbar-expand-lg main-navbar bg-white border-bottom-primary">
        <a href="." class="navbar-brand sidfebar-gone-hide d-sm-block">
            <img src="<?= $setting['logo'] ?>" width="50"> <?= $setting['nama_sekolah'] ?>
        </a>
        <a href="#" class="nav-link sidebar-gone-show mt-3" data-toggle="sidebar"><i class="fas fa-bars"></i></a>

        <form class="form-inline ml-auto">
            <ul class="navbar-nav"></ul>
        </form>
    </nav>

    <div id="app">

        <div class="main-wrapper container bg-light">

            <nav class="navbar navbar-secondary navbar-expand-lg main-navbar2" style="border: 1px #CB0C9F solid">
                <div class="container">
                    <ul class="navbar-nav">
                        <li class="nav-item">
                            <a href="#" class="nav-link klikmenu" data-id="beranda"><i class="fas fa-home text-primary"></i><span>Home</span></a>
                        </li>
                        <li class="nav-item">
                            <a href="#" class="nav-link klikmenu " data-id="pendaftaran"><i class="fas fa-heart text-primary"></i><span>Daftar Sekarang</span></a>
                        </li>
                        <li class="nav-item">
                            <a href="#" class="nav-link klikmenu" data-id="daftar"><i class="fas fa-user-friends text-primary"></i><span>Data Sudah Daftar</span></a>
                        </li>
                        <li class="nav-item">
                            <a href="#" class="nav-link klikmenu" data-id="pengumuman"><i class="fas fa-bullhorn text-primary"></i><span>Pengumuman</span></a>
                        </li>

                    </ul>
                    </span>

            </nav>

            <!-- Main Content -->
            <div class="main-content" style="margin-top: -50px;">
                <section class="section">
                    <div class="card p-2 border-bottom-primary">
                        <h2>AYO SEGERA DAFTAR KUOTA TERBATAS !</h2>
                        <div class="section-header-breadcrumb d-flex">
                            <button id="btndaftar" data-id="pendaftaran" type="button" class="klikmenu btn btn-primary animated  pulse delay-2s">DAFTAR SEKARANG</button> &nbsp;
                            <button id="btnmasuk" data-id="login" type="button" class="klikmenu btn bg-gradient-info">MASUK KE WEB</button>
                        </div>
                    </div>

                    <div class="section-body ">
                        <div id='isi_load'></div>

                        <div class="row animated bounceInUp">

                            <div class="col-12 col-sm-12 col-lg-12">
                                <div class="card border-bottom-primary d-none d-md-block">

                                    <div class="card-body">
                                        <div class="row">
                                            <div class="col-12 col-sm-12 col-md-4">
                                                <ul class="nav nav-pills flex-column bg-white" id="myTab4" role="tablist">
                                                    <li class="nav-item">
                                                        <a class="nav-link  active show" id="home-tab4" data-toggle="tab" href="#home4" role="tab" aria-controls="home" aria-selected="false">Informasi Pendaftaran</a>
                                                    </li>
                                                    <li class="nav-item">
                                                        <a class="nav-link" id="profile-tab4" data-toggle="tab" href="#profile4" role="tab" aria-controls="profile" aria-selected="false">Syarat Pendaftaran</a>
                                                    </li>
                                                    <li class="nav-item">
                                                        <a class="nav-link" id="contact-tab4" data-toggle="tab" href="#contact4" role="tab" aria-controls="contact" aria-selected="true">Kontak Pendaftaran</a>
                                                    </li>
                                                </ul>
                                            </div>
                                            <div class="col-12 col-sm-12 col-md-8">
                                                <div class="tab-content no-padding" id="myTab2Content">
                                                    <div class="tab-pane fade active show" id="home4" role="tabpanel" aria-labelledby="home-tab4">
                                                        <div class="row">
                                                            <div class="col-12">
                                                                <div class="activities">
                                                                    <div class="activity">
                                                                        <div class="activity-icon bg-primary text-white shadow-primary">
                                                                            1
                                                                        </div>
                                                                        <div class="activity-detail">
                                                                            <p>Calon Siswa mendaftar di web pendaftaran.</p>
                                                                            <p><button type="button" data-id="pendaftaran" class="btn klikmenu btn-primary">Daftar Sekarang</button>.</p>
                                                                        </div>
                                                                    </div>

                                                                </div>
                                                                <div class="activities">
                                                                    <div class="activity">
                                                                        <div class="activity-icon bg-primary text-white shadow-primary">
                                                                            2
                                                                        </div>
                                                                        <div class="activity-detail">
                                                                            <p>Jika selesai pendaftaran silahkan login dengan username dan password saat pendaftaran</p>
                                                                            <p><button type="button" data-id="login" class="klikmenu btn bg-gradient-info">Login Masuk</button>.</p>
                                                                        </div>
                                                                    </div>
                                                                </div>
                                                                <div class="activities">
                                                                    <div class="activity">
                                                                        <div class="activity-icon bg-primary text-white shadow-primary">
                                                                            3
                                                                        </div>
                                                                        <div class="activity-detail">
                                                                            <p>Lengkapi Formulir yang diberikan dengan data yang benar.</p>

                                                                        </div>
                                                                    </div>
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </div>
                                                    <div class="tab-pane fade" id="profile4" role="tabpanel" aria-labelledby="profile-tab4">
                                                        <?= $setting['syarat'] ?>
                                                    </div>
                                                    <div class="tab-pane fade " id="contact4" role="tabpanel" aria-labelledby="contact-tab4">
                                                        <div class=" author-box">
                                                            <div class="card-body">
                                                                <ul class="list-unstyled user-details list-unstyled-border list-unstyled-noborder">
                                                                    <?php $query = mysqli_query($koneksi, "select * from kontak where status='1'");
                                                                    while ($data = mysqli_fetch_array($query)) {
                                                                    ?>
                                                                        <li class="media">
                                                                            <img alt="image" class="mr-3 rounded-circle" width="50" src="assets/img/avatar/avatar-1.png">
                                                                            <div class="media-body">
                                                                                <div class="media-title"><?= $data['nama_kontak'] ?></div>
                                                                                <div class="text-job text-muted"><a href="https://api.whatsapp.com/send?phone=+62<?= $data['no_kontak'] ?>&text=<?= $setting['livechat'] ?>"> <?= $data['no_kontak'] ?></a></div>
                                                                            </div>
                                                                        </li>
                                                                    <?php } ?>
                                                                </ul>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <hr class="text-primary d-md-none d-block">

                        <div class="row d-md-none d-block">
                            <center>
                                <h5 class="text-primary">Bagaimana Cara Daftar?</h5>
                            </center>
                            <hr class="text-primary d-md-none d-block">
                            <div class="col-12">
                                <div class="activities">
                                    <div class="activity">
                                        <div class="activity-icon bg-primary text-white shadow-primary">
                                            1
                                        </div>
                                        <div class="activity-detail">
                                            <p>Calon Siswa mendaftar di web pendaftaran.</p>
                                            <p><button type="button" data-id="pendaftaran" class="btn klikmenu btn-primary">Daftar Sekarang</button>.</p>
                                        </div>
                                    </div>

                                </div>
                                <div class="activities">
                                    <div class="activity">
                                        <div class="activity-icon bg-primary text-white shadow-primary">
                                            2
                                        </div>
                                        <div class="activity-detail">
                                            <p>Jika selesai pendaftaran silahkan login dengan username dan password saat pendaftaran</p>
                                            <p><button type="button" data-id="login" class="klikmenu btn bg-gradient-info">Login Masuk</button>.</p>
                                        </div>
                                    </div>
                                </div>
                                <div class="activities">
                                    <div class="activity">
                                        <div class="activity-icon bg-primary text-white shadow-primary">
                                            3
                                        </div>
                                        <div class="activity-detail">
                                            <p>Lengkapi Formulir yang diberikan dengan data yang benar.</p>

                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <hr class="text-primary d-md-none d-block">
                    <div class="card border-bottom-primary d-md-none d-block">
                        <div class="card-body">
                            <div class="row">
                                <center>
                                    <h3>Syarat <span class="text-danger">*</span></h3>
                                </center>
                                <hr>
                                <div class="col-12 p-1">
                                    <?= $setting['syarat'] ?>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="card border-bottom-primary d-md-none d-block">
                        <div class="card-body">
                            <div class="row">
                                <center>
                                    <h3>Contact</h3>
                                </center>
                                <hr>
                                <div class="col-12">
                                    <div class=" author-box">
                                        <div class="card-body">
                                            <ul class="list-unstyled user-details list-unstyled-border list-unstyled-noborder">
                                                <?php $query = mysqli_query($koneksi, "select * from kontak where status='1'");
                                                while ($data = mysqli_fetch_array($query)) {
                                                ?>
                                                    <li class="media">
                                                        <img alt="image" class="mr-3 rounded-circle" width="50" src="assets/img/avatar/avatar-1.png">
                                                        <div class="media-body">
                                                            <div class="media-title"><?= $data['nama_kontak'] ?></div>
                                                            <div class="text-job text-muted"><a href="https://api.whatsapp.com/send?phone=+62<?= $data['no_kontak'] ?>&text=<?= $setting['livechat'] ?>"> <?= $data['no_kontak'] ?></a></div>
                                                        </div>
                                                    </li>
                                                <?php } ?>
                                            </ul>
                                        </div>

                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </section>
            </div>
            <footer class="main-footer bg-gradient-primary p-3">
                <div class="footer-left">
                    Copyright &copy; <?= date('Y') ?> PPDB <div class="bullet"></div>
                </div>
                <div class="footer-right">
                    Design By <a class="text-light" href="https://maugampang.com" target="_blank">MauGampang</a>
                </div>
            </footer>
        </div>
    </div>

    <!-- ui -->
    <script src="assets/ui/js/dashboard.js"></script>
    <script src="assets/ui/js/moment.js"></script>
    <script src="assets/ui/js/popper.min.js"></script>
    <script src="assets/ui/js/bootstrap.min.js"></script>
    <script src="assets/ui/js/perfect-scrollbar.min.js"></script>
    <script src="assets/ui/js/smooth-scrollbar.min.js"></script>
    <script src="assets/ui/js/soft-ui-dashboard.min.js"></script>

    <!-- General JS Scripts -->
    <script src="assets/modules/jquery.min.js"></script>
    <script src="assets/modules/popper.js"></script>
    <script src="assets/modules/tooltip.js"></script>
    <script src="assets/modules/bootstrap/js/bootstrap.min.js"></script>
    <script src="assets/modules/nicescroll/jquery.nicescroll.min.js"></script>
    <script src="assets/modules/moment.min.js"></script>
    <script src="assets/js/stisla.js"></script>

    <!-- JS Libraies -->
    <script src="assets/modules/select2/dist/js/select2.full.min.js"></script>
    <script src="assets/modules/bootstrap-daterangepicker/daterangepicker.js"></script>
    <script src="assets/modules/izitoast/js/iziToast.min.js"></script>
    <!-- Page Specific JS File -->

    <!-- JS DATATABLE -->
    <script src="assets/modules/datatables/datatables.min.js"></script>
    <script src="assets/modules/datatables/DataTables-1.10.16/js/dataTables.bootstrap4.min.js"></script>
    <script src="assets/modules/datatables/Select-1.2.4/js/dataTables.select.min.js"></script>

    <!-- Template JS File -->
    <script src="assets/js/scripts.js"></script>
    <script src="assets/js/custom.js"></script>
    <script type="text/javascript">
        $('.loader').fadeOut('slow');
        $(document).ready(function() {
            $('.klikmenu').click(function() {
                var menu = $(this).data('id');
                if (menu == "beranda") {
                    $('#btndaftar').show();
                    $('#isi_load').load('home.php');
                } else if (menu == "pendaftaran") {
                    $('#btndaftar').hide();
                    $('#isi_load').load('pendaftaran.php');
                } else if (menu == "daftar") {
                    $('#isi_load').load('datadaftar.php');
                } else if (menu == "pengumuman") {
                    $('#isi_load').load('pengumuman.php');
                } else if (menu == "login") {
                    $('#isi_load').load('login.php');
                }
            });


            // halaman yang di load default pertama kali
            $('#isi_load').load('home.php');

        });
    </script>
    <!-- <a href="#" class="ignielToTop"></a> -->
</body>

</html>